/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.supa.SparklingDaisyAftereffectProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SparklingDaisyAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sparkling_daisy", new Pair[]{ImmutablePair.of((Object)"Launches the user forward, slicing anything in their path", null)});
    private static final float COOLDOWN = 140.0f;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 25.0f;
    public static final AbilityCore<SparklingDaisyAbility> INSTANCE = new AbilityCore.Builder<SparklingDaisyAbility>("Sparkling Daisy", AbilityCategory.DEVIL_FRUITS, SparklingDaisyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(25.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::chargeStartsEvent).addEndEvent(this::chargeEndsEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::continuousTickEvent).addEndEvent(this::continuousEndsEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(20);
    private int initialY;
    private boolean isFull = false;
    private int projectiles = 1;

    public SparklingDaisyAbility(AbilityCore<SparklingDaisyAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.hitTrackerComponent, this.chargeComponent, this.animationComponent, this.continuousComponent, this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.initialY = (int)entity.func_226278_cu_();
        if (this.isFull) {
            this.chargeComponent.startCharging(entity, 40.0f);
        } else {
            Vector3d speed = entity.func_70040_Z().func_216372_d(7.0, 0.0, 7.0);
            AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 0.15, speed.field_72449_c);
            this.continuousComponent.startContinuity(entity, 10.0f);
        }
    }

    private void chargeStartsEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.SPARKLING_DAISY_CHARGE);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 100, 0));
    }

    private void chargeEndsEvent(LivingEntity entity, IAbility ability) {
        Vector3d dir = entity.func_70040_Z().func_216372_d(7.0, 0.0, 7.0);
        AbilityHelper.setDeltaMovement((Entity)entity, dir.field_72450_a, 0.15, dir.field_72449_c);
        this.animationComponent.stop(entity);
        this.continuousComponent.startContinuity(entity, 20.0f);
        entity.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
    }

    private void continuousEndsEvent(LivingEntity entity, IAbility ability) {
        if (this.isFull) {
            if (this.projectiles > 0) {
                for (int i = -this.projectiles; i <= this.projectiles; ++i) {
                    SparklingDaisyAftereffectProjectile proj = (SparklingDaisyAftereffectProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
                    proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z + (float)(i * 55), 0.0f, 0.85f, 1.0f);
                    entity.field_70170_p.func_217376_c((Entity)proj);
                }
            }
            this.animationComponent.stop(entity);
        }
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private void continuousTickEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S() && !entity.field_70170_p.field_72995_K && entity.func_226278_cu_() >= (double)this.initialY) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.6f);
            targets.remove(entity);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 25.0f);
            }
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (BlockPos location : WyHelper.getNearbyBlocks((Entity)entity, 3)) {
                if (!((double)location.func_177956_o() >= entity.func_226278_cu_()) || !AbilityHelper.placeBlockIfAllowed(entity, location, Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                positions.add(location);
            }
            if (positions.size() > 0) {
                this.details.setPositions(positions);
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
            }
        }
    }

    public void setFullForm() {
        this.isFull = true;
    }

    public void setProjectilesAmount(int amount) {
        this.projectiles = amount;
    }

    private SparklingDaisyAftereffectProjectile createProjectile(LivingEntity entity) {
        SparklingDaisyAftereffectProjectile proj = new SparklingDaisyAftereffectProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

