/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GroundDeathAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float RANGE_BONUS = 1.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ground_death", new Pair[]{ImmutablePair.of((Object)"Dries out the surrounding ground turning everything into sand.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and range is increased by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.5f) * 100.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 60;
    private static final int RANGE = 32;
    public static final AbilityCore<GroundDeathAbility> INSTANCE = new AbilityCore.Builder<GroundDeathAbility>("Ground Death", AbilityCategory.DEVIL_FRUITS, GroundDeathAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(60.0f), RangeComponent.getTooltip(32.0f, RangeComponent.RangeType.AOE)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.2).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();

    public GroundDeathAbility(AbilityCore<GroundDeathAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.hitTrackerComponent, this.rangeComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(SunaHelper::requiresInactiveDesertGirasole);
        super.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.blockPlacingHelper.clearList();
        this.rangeComponent.getBonusManager().removeBonus(SunaHelper.DESERT_RANGE_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.rangeComponent.getBonusManager().addBonus(SunaHelper.DESERT_RANGE_BONUS, "Desert Range Bonus", BonusOperation.MUL, 1.5f);
        }
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (float i = -32.0f; i < 32.0f; i += 1.0f) {
            for (int j = -8; j < 6; ++j) {
                for (float k = -32.0f; k < 32.0f; k += 1.0f) {
                    double posZ;
                    double posY;
                    double posX = entity.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange(16, 24) || (double)i > WyHelper.randomWithRange(16, 24) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    if (!AbilityHelper.canPlaceBlock(entity.field_70170_p, posX, posY = entity.func_226278_cu_() + (double)j, posZ = entity.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange(16, 24) || (double)k > WyHelper.randomWithRange(16, 24) ? WyHelper.randomWithRange(-5, 5) : 0.0), Blocks.field_150354_m.func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID)) continue;
                    mutpos.func_189532_c(posX, posY, posZ);
                    this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, (int)(i * i + (float)(j * j) + k * k));
                }
            }
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        Set<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            boolean isAir = entity.field_70170_p.func_180495_p(blockPos).func_196958_f();
            if (!isAir) {
                boolean isWater = entity.field_70170_p.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h;
                AbilityHelper.placeBlockIfAllowed(entity, blockPos, isWater ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150354_m.func_176223_P(), 259, GRIEF_RULE);
            }
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, blockPos, 1.5f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || target.func_110124_au() == entity.func_110124_au()) continue;
                AbilityHelper.createFilledCube(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1, (int)Math.round((double)target.func_70047_e() - target.func_226278_cu_()), 1, Blocks.field_150354_m, GRIEF_RULE);
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 3, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 200, 3, false, false));
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GROUND_DEATH.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            }
            iterator.remove();
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

