/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suke;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suke.ShishaNoTeProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class ShishaNoTeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shisha_no_te", new Pair[]{ImmutablePair.of((Object)"Shoots invisible projectiles that explode upon impact.", null)});
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<ShishaNoTeAbility> INSTANCE = new AbilityCore.Builder<ShishaNoTeAbility>("Shisha no Te", AbilityCategory.DEVIL_FRUITS, ShishaNoTeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.EXPLOSION).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public ShishaNoTeAbility(AbilityCore<ShishaNoTeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent, this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 6);
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private ShishaNoTeProjectile createProjectile(LivingEntity entity) {
        ShishaNoTeProjectile proj = new ShishaNoTeProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

