/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sube;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.SlidingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class SubeSubeSpurAbility
extends SlidingAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sube_sube_spur", new Pair[]{ImmutablePair.of((Object)"Allows the user to slide on the ground around using their feet.", null)});
    private static final double MAX_SPEED = 0.3;
    private static final double SLIDE_POWER = 1.74;
    public static final AbilityCore<SubeSubeSpurAbility> INSTANCE = new AbilityCore.Builder<SubeSubeSpurAbility>("Sube Sube Spur", AbilityCategory.DEVIL_FRUITS, SubeSubeSpurAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip()).build();
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Sube Sube Defelct Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);

    public SubeSubeSpurAbility(AbilityCore<SubeSubeSpurAbility> core) {
        super((AbilityCore<? extends SlidingAbility>)core);
        super.addComponents(this.changeStatsComponent);
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
    }

    @Override
    public double getMaxSpeed() {
        return 0.3;
    }

    @Override
    public double getSlidingPower() {
        return 1.74;
    }
}

