/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sube;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.events.FactionEvents;

public class SubeSubeDeflectAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sube_sube_deflect", new Pair[]{ImmutablePair.of((Object)"Temporarily makes the user immune to physical attacks, either by weapon or by hand to hand combat, as those attacks would just slip off their body.", null)});
    private static final List<String> BLOCK_SOURCES = Arrays.asList("mob", "player", "arrow", "sting", "trident", "thrown", "sweetBerryBush", "cactus");
    private static final int HOLD_TIME = 240;
    private static final int MIN_COOLDOWN = 80;
    private static final int MAX_COOLDOWN = 200;
    public static final AbilityCore<SubeSubeDeflectAbility> INSTANCE = new AbilityCore.Builder<SubeSubeDeflectAbility>("Sube Sube Deflect", AbilityCategory.DEVIL_FRUITS, SubeSubeDeflectAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f, 200.0f), ContinuousComponent.getTooltip(240.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::damageTakenEvent);

    public SubeSubeDeflectAbility(AbilityCore<SubeSubeDeflectAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 240.0f);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = 80.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float damageTakenEvent(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.isContinuous()) {
            return damage;
        }
        if (FactionEvents.isDirectHit(damageSource)) {
            return 0.0f;
        }
        if (damageSource.func_76364_f() instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)damageSource.func_76364_f()).isPhysical()) {
            return 0.0f;
        }
        if (BLOCK_SOURCES.contains(damageSource.func_76355_l())) {
            return 0.0f;
        }
        return damage;
    }
}

