/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HornDashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "horn_dash", new Pair[]{ImmutablePair.of((Object)"Running into enemies deals damage and knocks them back.", null)});
    private static final int COOLDOWN = 180;
    private static final int HOLD_TIME = 20;
    private static final float AREA_SIZE = 1.7f;
    private static final float DAMAGE = 10.0f;
    public static final AbilityCore<HornDashAbility> INSTANCE = new AbilityCore.Builder<HornDashAbility>("Horn Dash", AbilityCategory.DEVIL_FRUITS, HornDashAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(180.0f), ContinuousComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(10.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(100, this::stopContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.SAI_HEAVY.get(), (MorphInfo)ModMorphs.SAI_WALK.get());

    public HornDashAbility(AbilityCore<HornDashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.requireMorphComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion(entity, 3.0, 3.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 0.2, speed.field_72449_c);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.continuousComponent.startContinuity(entity, 20.0f);
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, 1.7f);
        for (LivingEntity target : list) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
            Vector3d speed = WyHelper.propulsion(entity, 3.0, 3.0);
            AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 0.5, speed.field_72449_c);
        }
    }
}

