/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.ope.OpeHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class InjectionShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "injection_shot", new Pair[]{ImmutablePair.of((Object)"While holding a weapon, the user charges at the enemy, leaving them confused.", null)});
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 40.0f;
    private static final float RANGE = 1.6f;
    public static final AbilityCore<InjectionShotAbility> INSTANCE = new AbilityCore.Builder<InjectionShotAbility>("Injection Shot", AbilityCategory.DEVIL_FRUITS, InjectionShotAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(40.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public InjectionShotAbility(AbilityCore<InjectionShotAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.animationComponent, this.rangeComponent);
        super.addCanUseCheck(OpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!AbilityHelper.canUseMomentumAbilities(entity)) {
            return;
        }
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_WEAPON);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 100, 0));
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail()) {
            this.chargeComponent.stopCharging(entity);
        }
        entity.field_70177_z = entity.field_70126_B;
        entity.field_70125_A = entity.field_70127_C;
        if (entity instanceof PlayerEntity) {
            EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
            ((ServerPlayerEntity)entity).field_71135_a.func_175089_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70126_B, entity.field_70127_C, flags);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
        if (super.canUse(entity).isSuccess()) {
            this.continuousComponent.startContinuity(entity, 20.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Vector3d dirVec = entity.func_70040_Z().func_216372_d(4.0, 1.0, 4.0);
        AbilityHelper.setDeltaMovement((Entity)entity, dirVec.field_72450_a, 0.35, dirVec.field_72449_c);
        this.hitTrackerComponent.clearHits();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (entity.func_70089_S()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.6f);
            ModDamageSource source = ((ModDamageSource)((Object)((AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash())).setPiercing(0.5f);
            targets.remove(entity);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)entity) || !this.dealDamageComponent.hurtTarget(entity, target, 40.0f, source)) continue;
                target.func_195064_c(new EffectInstance(Effects.field_76431_k, 60, 0));
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

