/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nagi;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class SilentAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "silent", new Pair[]{ImmutablePair.of((Object)"Cancels all noises caused by or around the user.", null)});
    private static final TargetsPredicate TARGET_CHECK = new TargetsPredicate();
    private static final int RANGE = 30;
    public static final AbilityCore<SilentAbility> INSTANCE = new AbilityCore.Builder<SilentAbility>("Silent", AbilityCategory.DEVIL_FRUITS, SilentAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, RangeComponent.getTooltip(30.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public SilentAbility(AbilityCore<SilentAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 15.0f == 0.0f) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 30.0f, TARGET_CHECK);
            for (LivingEntity target : targets) {
                EffectInstance inst = new EffectInstance((Effect)ModEffects.SILENT.get(), 20, 0, false, false);
                target.func_195064_c(inst);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class SilentAbilityClientEvents {
        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.func_70644_a((Effect)ModEffects.SILENT.get()) && entity.field_70170_p.field_72995_K && entity.field_70173_aa % 20 == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147690_c();
            }
        }

        @SubscribeEvent
        public static void onSoundPlayed(PlaySoundEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                return;
            }
            BlockPos soundPos = new BlockPos(event.getSound().func_147649_g(), event.getSound().func_147654_h(), event.getSound().func_147651_i());
            if (mc.field_71439_g.func_70644_a((Effect)ModEffects.SILENT.get()) && soundPos.func_218141_a((Vector3i)mc.field_71439_g.func_233580_cy_(), 30.0)) {
                event.setResultSound(null);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class SilentAbilityServerEvents {
        @SubscribeEvent
        public static void onServerMessage(ServerChatEvent event) {
            boolean isNagiUser;
            ServerPlayerEntity player = event.getPlayer();
            IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
            SilentAbility ability = abilityData.getEquippedAbility(INSTANCE);
            boolean bl = isNagiUser = ability != null && ability.isContinuous();
            if (player.func_70644_a((Effect)ModEffects.SILENT.get()) && !isNagiUser) {
                event.setCanceled(true);
                return;
            }
        }
    }
}

