/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.WhiteOutProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class WhiteOutAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_out", new Pair[]{ImmutablePair.of((Object)"Fires both fists at an enemy and lifts them up, moving them around according to the user's movements", null)});
    private static final int COOLDOWN = 240;
    private static final int HOLD_TIME = 60;
    public static final AbilityCore<WhiteOutAbility> INSTANCE = new AbilityCore.Builder<WhiteOutAbility>("White Out", AbilityCategory.DEVIL_FRUITS, WhiteOutAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ContinuousComponent.getTooltip(60.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setSourceElement(SourceElement.SMOKE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private LivingEntity grabbedEntity = null;
    private WhiteOutProjectile proj = null;

    public WhiteOutAbility(AbilityCore<WhiteOutAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.proj = (WhiteOutProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
        this.proj.onEntityImpactEvent = hit -> {
            this.grabbedEntity = hit;
        };
        entity.field_70170_p.func_217376_c((Entity)this.proj);
        this.proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(this.proj != null && this.proj.func_70089_S() || this.grabbedEntity != null)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.grabbedEntity != null && (!this.grabbedEntity.func_70089_S() || AbilityHelper.isGuardBlocking(this.grabbedEntity))) {
            this.continuousComponent.stopContinuity(entity);
        } else if (this.grabbedEntity != null) {
            this.grabbedEntity.field_70177_z = this.grabbedEntity.field_70126_B;
            this.grabbedEntity.field_70125_A = this.grabbedEntity.field_70127_C;
            this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
            this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.SMOKE.get(), 60, 0));
            double distance = 7.0;
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d pos = new Vector3d(lookVec.field_72450_a * distance, (double)entity.func_70047_e() / 2.0 + lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
            AbilityHelper.setDeltaMovement((Entity)this.grabbedEntity, entity.func_213303_ch().func_178787_e(pos).func_178788_d(this.grabbedEntity.func_213303_ch()));
            if (this.grabbedEntity instanceof ServerPlayerEntity) {
                EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                ((ServerPlayerEntity)this.grabbedEntity).field_71135_a.func_175089_a(this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), this.grabbedEntity.field_70126_B, this.grabbedEntity.field_70127_C, flags);
            }
            this.grabbedEntity.field_70143_R = 0.0f;
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.proj = null;
        this.grabbedEntity = null;
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private WhiteOutProjectile createProjectile(LivingEntity entity) {
        WhiteOutProjectile proj = new WhiteOutProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

