/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.magu.RyuseiKazanProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class RyuseiKazanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ryusei_kazan", new Pair[]{ImmutablePair.of((Object)"Functions like 'Dai Funka', but multiple fists are launched at the opponent", null)});
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<RyuseiKazanAbility> INSTANCE = new AbilityCore.Builder<RyuseiKazanAbility>("Ryusei Kazan", AbilityCategory.DEVIL_FRUITS, RyuseiKazanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.MAGMA).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public RyuseiKazanAbility(AbilityCore<RyuseiKazanAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 10, 5);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        Vector3d lookVec = entity.func_70040_Z().func_72432_b();
        RyuseiKazanProjectile proj = (RyuseiKazanProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
        if (lookVec.field_72448_b > 0.7) {
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 8.0f);
            proj.setMaxLife(300);
            proj.setGravity(0.05f);
        } else {
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.5f, 4.0f);
        }
        entity.field_70170_p.func_217376_c((Entity)proj);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MAGU_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private RyuseiKazanProjectile createProjectile(LivingEntity entity) {
        return new RyuseiKazanProjectile(entity.field_70170_p, entity, this);
    }
}

