/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.magu.MeigoProjectile;

public class MeigoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "meigo", new Pair[]{ImmutablePair.of((Object)"The user transforms their arm into magma and thrusts it at the opponent at incredible speeds", null)});
    private static final float COOLDOWN = 600.0f;
    public static final AbilityCore<MeigoAbility> INSTANCE = new AbilityCore.Builder<MeigoAbility>("Meigo", AbilityCategory.DEVIL_FRUITS, MeigoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.MAGMA).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public MeigoAbility(AbilityCore<MeigoAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.projectileComponent);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 1.5f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private MeigoProjectile createProjectile(LivingEntity entity) {
        return new MeigoProjectile(entity.field_70170_p, entity, this);
    }
}

