/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class BakuretsuKazanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bakuretsu_kazan", new Pair[]{ImmutablePair.of((Object)"By spreading magma to the surroundings, the user turns everything into lava", null)});
    private static final float MAX_CHARGE_TIME = 100.0f;
    private static final float MIN_COOLDOWN = 100.0f;
    private static final float MAX_COOLDOWN = 600.0f;
    public static final AbilityCore<BakuretsuKazanAbility> INSTANCE = new AbilityCore.Builder<BakuretsuKazanAbility>("Bakuretsu Kazan", AbilityCategory.DEVIL_FRUITS, BakuretsuKazanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 600.0f)).setSourceElement(SourceElement.MAGMA).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() >= 0.3).addEndEvent(this::onChargeEnd);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE).build();

    public BakuretsuKazanAbility(AbilityCore<BakuretsuKazanAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int range = (int)(this.chargeComponent.getChargePercentage() * 16.0f);
        AbilityHelper.createFilledSphere(entity.field_70170_p, (int)entity.func_226277_ct_(), (int)entity.func_226278_cu_(), (int)entity.func_226281_cx_(), range, Blocks.field_150353_l, GRIEF_RULE);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BAKURETSU_KAZAN.get(), SoundCategory.PLAYERS, 10.0f, 1.0f);
        float cooldown = 100.0f + this.chargeComponent.getChargeTime() * 5.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

