/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kuku;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GourmetSnipeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gourmet_snipe", new Pair[]{ImmutablePair.of((Object)"Launches the user forward and converts everything cut into food.", null)});
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();
    private static final ArrayList<Item> FOODS = new ArrayList<Item>(Arrays.asList(Items.field_151077_bg, Items.field_179559_bp, Items.field_196102_ba, Items.field_151034_e, Items.field_179557_bn, Items.field_196104_bb, Items.field_226638_pX_, Items.field_151157_am));
    private static final int HOLD_TIME = 10;
    private static final int COOLDOWN = 400;
    private static final float RANGE = 2.0f;
    private static final float DAMAGE = 20.0f;
    public static final AbilityCore<GourmetSnipeAbility> INSTANCE = new AbilityCore.Builder<GourmetSnipeAbility>("Gourmet Snipe", AbilityCategory.DEVIL_FRUITS, GourmetSnipeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), RangeComponent.getTooltip(2.0f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(20.0f)).setSourceType(SourceType.PHYSICAL).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(20);
    private int initialY;

    public GourmetSnipeAbility(AbilityCore<GourmetSnipeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.initialY = (int)entity.func_226278_cu_();
        Vector3d speed = entity.func_70040_Z().func_216372_d(6.0, 6.0, 6.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        this.continuousComponent.startContinuity(entity, 10.0f);
        this.animationComponent.start(entity, ModAnimations.SHOOT_SELF_FORWARD);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Vector3d speed = entity.func_70040_Z().func_216372_d(1.6, 1.0, 1.6);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, entity.func_213322_ci().func_82617_b(), speed.field_72449_c);
        if (entity.func_70089_S()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
            }
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (BlockPos location : WyHelper.getNearbyBlocks((Entity)entity, 2)) {
                if (location.func_177956_o() < this.initialY || !AbilityHelper.placeBlockIfAllowed(entity, location, Blocks.field_150350_a.func_176223_P(), GRIEF_RULE)) continue;
                if (entity.field_70170_p.field_73012_v.nextDouble() > 0.4) {
                    ItemStack foodStack = new ItemStack((IItemProvider)FOODS.get((int)WyHelper.randomWithRange(0, FOODS.size() - 1)));
                    entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.field_70170_p, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p(), foodStack));
                }
                positions.add(location);
            }
            if (positions.size() > 0) {
                this.details.setPositions(positions);
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

