/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kira;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CabochonKnuckleAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cabochon_knuckle", new Pair[]{ImmutablePair.of((Object)"Covers the user's punch in a diamond coating, dealing damage and slight knockback.", null)});
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.DIAMOND_BODY).setOverlayPart(AbilityOverlay.OverlayPart.LIMB).build();
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<CabochonKnuckleAbility> INSTANCE = new AbilityCore.Builder<CabochonKnuckleAbility>("Cabochon Knuckle", AbilityCategory.DEVIL_FRUITS, CabochonKnuckleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public CabochonKnuckleAbility(AbilityCore<CabochonKnuckleAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.skinOverlayComponent);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart);
        this.continuousComponent.addEndEvent(100, this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        Vector3d speed = WyHelper.propulsion(entity, 3.0, 3.0);
        AbilityHelper.setDeltaMovement((Entity)target, target.func_213322_ci().func_72441_c(speed.field_72450_a, 0.5, speed.field_72449_c));
        target.func_230245_c_(false);
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchDamage() {
        return 15.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 160.0f;
    }

    @Override
    public int getUseLimit() {
        return 1;
    }
}

