/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kilo;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class KiloPunch5000Ability
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "5000_kilo_press", new Pair[]{ImmutablePair.of((Object)"Delivers a 5000 kilo punch, the user is slowed down due to the extra kilos", null)});
    private static final float COOLDOWN = 140.0f;
    public static final AbilityCore<KiloPunch5000Ability> INSTANCE = new AbilityCore.Builder<KiloPunch5000Ability>("5000 Kilo Punch", AbilityCategory.DEVIL_FRUITS, KiloPunch5000Ability::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private static final AbilityAttributeModifier MOVEMENT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("969f4880-faf9-41e9-bdae-26a57422254a"), INSTANCE, "Kilo Punch 5000 Movement Modifier", -0.01, AttributeModifier.Operation.ADDITION);

    public KiloPunch5000Ability(AbilityCore<KiloPunch5000Ability> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_MODIFIER, this.canActivate());
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchDamage() {
        return 20.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 140.0f;
    }
}

