/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.kage.TsunoTokagePillarEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TsunoTokageAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tsuno_tokage", new Pair[]{ImmutablePair.of((Object)"The user creates a lizard-like shadow under his opponent, which pierces them from below", null)});
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<TsunoTokageAbility> INSTANCE = new AbilityCore.Builder<TsunoTokageAbility>("Tsuno Tokage", AbilityCategory.DEVIL_FRUITS, TsunoTokageAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public TsunoTokageAbility(AbilityCore<TsunoTokageAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 64.0);
        if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        TsunoTokagePillarEntity pillar = (TsunoTokagePillarEntity)((Object)this.projectileComponent.getNewProjectile(entity));
        pillar.func_70012_b(i, j - 6.0, k, 0.0f, 0.0f);
        pillar.func_70186_c(0.0, 0.7, 0.0, 1.4f, 0.0f);
        entity.field_70170_p.func_217376_c((Entity)pillar);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private TsunoTokagePillarEntity createProjectile(LivingEntity entity) {
        TsunoTokagePillarEntity pillar = new TsunoTokagePillarEntity(entity.field_70170_p, entity);
        return pillar;
    }
}

