/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.kage.BlackBoxProjectile;

public class BlackBoxAbility
extends Ability {
    private static final float COOLDOWN = 320.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "black_box", new Pair[]{ImmutablePair.of((Object)"Encases and suffocates the opponent in a box made of shadows.", null)});
    public static final AbilityCore<BlackBoxAbility> INSTANCE = new AbilityCore.Builder<BlackBoxAbility>("Black Box", AbilityCategory.DEVIL_FRUITS, BlackBoxAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(320.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public BlackBoxAbility(AbilityCore<BlackBoxAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 0.5f);
        this.cooldownComponent.startCooldown(entity, 320.0f);
    }

    private BlackBoxProjectile createProjectile(LivingEntity entity) {
        BlackBoxProjectile proj = new BlackBoxProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

