/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class PunkPistolsAbility
extends RepeaterAbility2 {
    private static final int VALUE_PER_SPEAR = 5;
    private static final int SPEARS = 6;
    private static final int INTERVAL = 4;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "punk_pistols", new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic objects from the user's inventory to form %s spears and shoots them at enemies.", (Object)new Object[]{AbilityHelper.mentionText(30), AbilityHelper.mentionText(6)})});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<PunkPistolsAbility> INSTANCE = new AbilityCore.Builder<PunkPistolsAbility>("Punk Pistols", AbilityCategory.DEVIL_FRUITS, PunkPistolsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public PunkPistolsAbility(AbilityCore<PunkPistolsAbility> core) {
        super((AbilityCore<? extends RepeaterAbility2>)core);
        this.addComponents(this.animationComponent);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
        this.repeaterComponent.addTriggerEvent(this::triggerRepeaterEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        if (!JikiHelper.hasEnoughIron(inventory, 5.0f)) {
            entity.func_145747_a((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_MATERIALS, Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        JikiHelper.spawnAttractEffect((Entity)entity);
    }

    @Override
    public int getMaxTriggers() {
        return 6;
    }

    @Override
    public int getTriggerInterval() {
        return 4;
    }

    @Override
    public float getRepeaterCooldown() {
        return 240.0f;
    }

    public PunkPistolProjectile getProjectileFactory(LivingEntity entity) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        List<ItemStack> components = JikiHelper.getMagneticItemsNeeded(inventory, 5.0f);
        PunkPistolProjectile proj = new PunkPistolProjectile(entity.field_70170_p, entity, components);
        return proj;
    }
}

