/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JikiHelper {
    public static Ability.ICanUseEvent getMetalicItemsCheck(int amount) {
        return (entity, ability) -> {
            List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
            if (!JikiHelper.hasEnoughIron(inventory, amount)) {
                return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_MATERIALS);
            }
            return AbilityUseResult.success();
        };
    }

    public static void spawnAttractEffect(Entity source) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ATTRACT.get(), source, source.func_226277_ct_(), source.func_226278_cu_(), source.func_226281_cx_());
    }

    public static List<ItemStack> getMagneticItemsOnPlayer(PlayerEntity player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        inventory.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
        inventory.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
        inventory.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
        return inventory;
    }

    public static List<ItemStack> getMagneticItemsNeeded(List<ItemStack> inventory, float threshold) {
        ArrayList<ItemStack> stacksUsed = new ArrayList<ItemStack>();
        for (ItemStack stack : inventory) {
            int neededQty;
            if (threshold <= 0.0f) break;
            if (stack == null || stack.func_190926_b() || !stack.func_77973_b().func_206844_a(ModTags.Items.MAGNETIC) || EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.KAIROSEKI.get())) continue;
            float amount = ModTags.Items.IRON.getValue(stack.func_77973_b());
            ItemStack clone = ItemStack.func_199557_a((CompoundNBT)stack.func_77955_b(new CompoundNBT()));
            if (stack.func_77984_f()) {
                stacksUsed.add(clone);
                stack.func_190918_g(1);
                threshold -= amount;
                continue;
            }
            int qty = stack.func_190916_E();
            if (qty < (neededQty = (int)Math.ceil(threshold / amount))) {
                stacksUsed.add(clone);
                stack.func_190918_g(qty);
                threshold -= (float)qty * amount;
                continue;
            }
            ItemStack split = stack.func_77979_a(neededQty);
            stacksUsed.add(split);
            threshold -= (float)split.func_190916_E() * amount;
        }
        return stacksUsed;
    }

    public static boolean hasEnoughIron(List<ItemStack> list, float threshold) {
        return JikiHelper.getIronAmount(list) >= threshold;
    }

    public static float getIronAmount(List<ItemStack> list) {
        float totalAmount = 0.0f;
        for (ItemStack stack : list) {
            if (stack == null || stack.func_190926_b() || EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.KAIROSEKI.get()) || !stack.func_77973_b().func_206844_a(ModTags.Items.MAGNETIC)) continue;
            float value = ModTags.Items.IRON.getValue(stack.func_77973_b());
            totalAmount += value * (float)stack.func_190916_E();
        }
        return totalAmount;
    }

    @Deprecated
    public static void dropComponentItems(PlayerEntity player, BlockPos pos, List<ItemStack> list) {
        JikiHelper.dropComponentItems((LivingEntity)player, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), list);
    }

    public static void dropComponentItems(LivingEntity entity, Vector3d pos, List<ItemStack> list) {
        JikiHelper.damageMagneticItems(entity, list);
        for (ItemStack stack : list) {
            int splits = entity.func_70681_au().nextInt(4) + 2;
            for (int i = 0; i < splits; ++i) {
                ItemStack split = stack.func_77979_a(stack.func_190916_E() / splits);
                ItemEntity item = new ItemEntity(entity.field_70170_p, pos.func_82615_a(), pos.func_82617_b() + (double)0.4f, pos.func_82616_c(), split);
                item.func_174867_a(20);
                entity.field_70170_p.func_217376_c((Entity)item);
            }
            ItemEntity item = new ItemEntity(entity.field_70170_p, pos.func_82615_a(), pos.func_82617_b() + (double)0.4f, pos.func_82616_c(), stack);
            item.func_174867_a(20);
            entity.field_70170_p.func_217376_c((Entity)item);
        }
    }

    public static void damageMagneticItems(LivingEntity entity, List<ItemStack> list) {
        for (ItemStack stack : list) {
            if (stack == null || stack.func_190926_b()) continue;
            float value = ModTags.Items.IRON.getValue(stack.func_77973_b());
            float chance = MathHelper.func_76131_a((float)(10.0f / value), (float)0.0f, (float)50.0f);
            boolean canBreak = (float)entity.func_70681_au().nextInt(100) + entity.func_70681_au().nextFloat() < chance;
            if (!canBreak) continue;
            if (stack.func_77984_f()) {
                int maxDamage = stack.func_77958_k();
                int damage = (int)WyHelper.clamp(entity.func_70681_au().nextInt(maxDamage), 50L, maxDamage);
                stack.func_222118_a(damage, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
                continue;
            }
            if (!(value > 0.0f)) continue;
            int maxCount = 1 + (int)((float)stack.func_190916_E() / value);
            int destroy = (int)WyHelper.clamp(entity.func_70681_au().nextInt(maxCount), 1L, maxCount);
            stack.func_190918_g(destroy);
        }
    }
}

