/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ito.StringPillarProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FullbrightAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "fullbright", new Pair[]{ImmutablePair.of((Object)"Throws five strings to impale a target from above.", null)});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 20;
    public static final AbilityCore<FullbrightAbility> INSTANCE = new AbilityCore.Builder<FullbrightAbility>("Fullbright", AbilityCategory.DEVIL_FRUITS, FullbrightAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::startChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private LivingEntity target;

    public FullbrightAbility(AbilityCore<FullbrightAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent, this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM, 20);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = null;
        if (this.target == null) {
            mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 32.0);
        }
        for (int a = 0; a < 5; ++a) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.target != null) {
                x = this.target.func_226277_ct_();
                y = this.target.func_226278_cu_();
                z = this.target.func_226281_cx_();
            } else if (mop != null) {
                x = mop.func_216347_e().field_72450_a;
                y = mop.func_216347_e().field_72448_b;
                z = mop.func_216347_e().field_72449_c;
            } else {
                return;
            }
            double i = x + WyHelper.randomDouble() * 2.0;
            double j = y;
            double k = z + WyHelper.randomDouble() * 2.0;
            StringPillarProjectile pillar = (StringPillarProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            pillar.func_70107_b(i, j + 24.0, k);
            AbilityHelper.setDeltaMovement((Entity)pillar, 0.0, -1.75, 0.0);
            entity.field_70170_p.func_217376_c((Entity)pillar);
        }
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private StringPillarProjectile createProjectile(LivingEntity entity) {
        StringPillarProjectile pillar = new StringPillarProjectile(entity.field_70170_p, entity, this);
        pillar.field_70125_A = 90.0f;
        return pillar;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }
}

