/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horo;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.horo.TokuHollowProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TokuHollowAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "toku_hollow", new Pair[]{ImmutablePair.of((Object)"Creates a huge ghost that causes a massive explosion upon impact.", null)});
    private static final int COOLDOWN = 300;
    public static final AbilityCore<TokuHollowAbility> INSTANCE = new AbilityCore.Builder<TokuHollowAbility>("Toku Hollow", AbilityCategory.DEVIL_FRUITS, TokuHollowAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public TokuHollowAbility(AbilityCore<TokuHollowAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.projectileComponent);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity);
        this.cooldownComponent.startCooldown(entity, WyHelper.secondsToTicks(15.0f));
    }

    private TokuHollowProjectile createProjectile(LivingEntity entity) {
        TokuHollowProjectile proj = new TokuHollowProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

