/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hie;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class IceSaberAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ice_saber", new Pair[]{ImmutablePair.of((Object)"Creates a sharp blade made of compressed ice", null)});
    public static final AbilityCore<IceSaberAbility> INSTANCE = new AbilityCore.Builder<IceSaberAbility>("Ice Saber", AbilityCategory.DEVIL_FRUITS, IceSaberAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.ICE).setSourceType(SourceType.SLASH).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    private final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent(this);

    public IceSaberAbility(AbilityCore<IceSaberAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.itemSpawnComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, new ItemStack((IItemProvider)ModWeapons.ICE_SABER.get()));
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.despawnItems(entity);
    }
}

