/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.HanaHelper;
import xyz.pixelatedw.mineminenomi.abilities.hana.MilFleurAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaGenericEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaHandsEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class SeisFleurSlapAbility
extends Ability {
    private static final int MIL_DISTANCE = 20;
    private static final float DAMAGE_BONUS = 1.25f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "seis_fleur_slap", new Pair[]{ImmutablePair.of((Object)"Slaps the enemy pushing them few blocks back and dealing some damage.", null), ImmutablePair.of((Object)"While %s is active it will sprout on every enemy in a %s blocks radius and increase its damage by %s.", (Object)new Object[]{MilFleurAbility.INSTANCE, "\u00a7a20\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.25f) * 100.0f) + "%\u00a7r"})});
    private static final TranslationTextComponent NORMAL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.seis_fleur_slap", "Seis Fleur: Slap"));
    private static final TranslationTextComponent MIL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.mil_fleur_slap", "Mil Fleur: Slap"));
    private static final ResourceLocation NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/seis_fleur_slap.png");
    private static final ResourceLocation MIL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/mil_fleur_slap.png");
    private static final int COOLDOWN = 100;
    private static final int NORMAL_DAMAGE = 6;
    public static final AbilityCore<SeisFleurSlapAbility> INSTANCE = new AbilityCore.Builder<SeisFleurSlapAbility>("Seis Fleur: Slap", AbilityCategory.DEVIL_FRUITS, SeisFleurSlapAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), DealDamageComponent.getTooltip(6.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final AltModeComponent<MilFleurAbility.Mode> altModeComponent = new AltModeComponent<MilFleurAbility.Mode>(this, MilFleurAbility.Mode.class, MilFleurAbility.Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public SeisFleurSlapAbility(AbilityCore<SeisFleurSlapAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent, this.altModeComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS, 7);
        MilFleurAbility milFleur = AbilityDataCapability.get(entity).getEquippedAbility(MilFleurAbility.INSTANCE);
        boolean hasMilFleur = milFleur != null && milFleur.isContinuous();
        this.dealDamageComponent.getBonusManager().removeBonus(HanaHelper.MIL_DAMAGE_BONUS);
        if (hasMilFleur) {
            this.dealDamageComponent.getBonusManager().addBonus(HanaHelper.MIL_DAMAGE_BONUS, "Mil Fleur Damage Bonus", BonusOperation.MUL, 1.25f);
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 20.0f);
            for (LivingEntity target : targets) {
                this.slap(entity, (Entity)target);
            }
        } else {
            this.projectileComponent.shoot(entity, 6.0f, 0.0f);
        }
        HanaHelper.spawnBlossomEffect(entity);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private HanaGenericEntity createProjectile(LivingEntity entity) {
        HanaGenericEntity proj = new HanaGenericEntity(entity.field_70170_p, entity, this);
        proj.onEntityImpactEvent = target -> this.slap(entity, (Entity)target);
        return proj;
    }

    private void slap(LivingEntity entity, @Nullable Entity targetEntity) {
        if (targetEntity != null && targetEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)targetEntity;
            HanaHandsEntity slap = new HanaHandsEntity(entity.field_70170_p, this);
            slap.setWarmup(0);
            slap.setCaster(entity);
            slap.setTarget(target);
            slap.setDamage(6.0f);
            slap.setSlap();
            entity.field_70170_p.func_217376_c((Entity)slap);
            Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b();
            AbilityHelper.setDeltaMovement((Entity)target, -dirVec.field_72450_a * 3.0, entity.func_213322_ci().func_82617_b() + 0.1, -dirVec.field_72449_c * 3.0);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.HANA_HANDS.get(), 5, 0, false, false));
            HanaHelper.spawnBlossomEffect(target);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, MilFleurAbility.Mode mode) {
        if (mode == MilFleurAbility.Mode.NORMAL) {
            this.setDisplayName((ITextComponent)NORMAL_NAME);
            this.setDisplayIcon(NORMAL_ICON);
        } else if (mode == MilFleurAbility.Mode.MIL_FLEUR) {
            this.setDisplayName((ITextComponent)MIL_NAME);
            this.setDisplayIcon(MIL_ICON);
        }
    }

    public void switchNormalMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, MilFleurAbility.Mode.NORMAL);
    }

    public void switchMilMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, MilFleurAbility.Mode.MIL_FLEUR);
    }
}

