/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.HanaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaFeetEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CienFleurStompAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cien_fleur_stomp", new Pair[]{ImmutablePair.of((Object)"Stomps the ground in front of the user using giant feet.", null)});
    private static final int COOLDOWN = 200;
    private static final int TRIGGERS = 7;
    private static final int INTERVAL = 4;
    private static final int RANGE = 10;
    public static final AbilityCore<CienFleurStompAbility> INSTANCE = new AbilityCore.Builder<CienFleurStompAbility>("Cien Fleur: Stomp", AbilityCategory.DEVIL_FRUITS, CienFleurStompAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private Iterator<BlockPos> targetedBlocks;

    public CienFleurStompAbility(AbilityCore<CienFleurStompAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
        HanaHelper.spawnBlossomEffect(entity);
        Predicate<BlockPos> predicate = pos -> entity.field_70170_p.func_180495_p(pos.func_177984_a()).func_196958_f() && (double)pos.func_177956_o() > entity.func_226278_cu_() - 3.0;
        Vector3d look = entity.func_213303_ch().func_178787_e(entity.func_70040_Z().func_216372_d(7.0, 1.0, 7.0));
        BlockPos ogPos = new BlockPos(look.func_82615_a(), entity.func_226278_cu_(), look.func_82616_c());
        List<BlockPos> poses = WyHelper.getNearbyBlocks(ogPos, (IWorld)entity.field_70170_p, 10, predicate, (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
        this.targetedBlocks = WyHelper.shuffle(poses).stream().limit(7L).iterator();
        this.repeaterComponent.start(entity, 7, 4);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        if (this.targetedBlocks == null || !this.targetedBlocks.hasNext()) {
            return;
        }
        BlockPos pos = this.targetedBlocks.next();
        HanaFeetEntity stompFeet = (HanaFeetEntity)((Object)this.projectileComponent.getNewProjectile(entity));
        stompFeet.func_225653_b_(pos.func_177958_n(), pos.func_177956_o() + 15, pos.func_177952_p());
        AbilityHelper.setDeltaMovement((Entity)stompFeet, 0.0, -0.9, 0.0);
        entity.field_70170_p.func_217376_c((Entity)stompFeet);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private HanaFeetEntity createProjectile(LivingEntity entity) {
        HanaFeetEntity stompFeet = new HanaFeetEntity(entity.field_70170_p, entity, this);
        return stompFeet;
    }
}

