/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class KenbunshokuHakiAuraAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kenbunshoku_haki_aura", new Pair[]{ImmutablePair.of((Object)"Uses Observation Haki to see the auras of all nearby creatures, differentiated by colors.", null)});
    private static final int HOLD_TIME = 2400;
    private static final int MIN_COOLDOWN = 60;
    public static final AbilityCore<KenbunshokuHakiAuraAbility> INSTANCE = new AbilityCore.Builder<KenbunshokuHakiAuraAbility>("Kenbunshoku Haki: Aura", AbilityCategory.HAKI, KenbunshokuHakiAuraAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(KenbunshokuHakiAuraAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);

    public KenbunshokuHakiAuraAbility(AbilityCore<KenbunshokuHakiAuraAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 2400.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.KENBUNSHOKU_HAKI_ON_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.KENBUNSHOKU_HAKI_OFF.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        float cooldown = Math.max(60.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private static boolean canUnlock(LivingEntity user) {
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        return statsProps.getDoriki() > 1500.0 && (double)props.getKenbunshokuHakiExp() > HakiHelper.getKenbunshokuAuraExpNeeded(user);
    }
}

