/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.KariParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KariAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/kari.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/kari.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kari", new Pair[]{ImmutablePair.of((Object)"The user heats the air around them with lightning until it explodes with a thunder clap.", null), ImmutablePair.of((Object)"Can be used to avoid and neutralize projectiles.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int MIN_COOLDOWN = 60;
    private static final int MAX_COOLDOWN = 240;
    private static final int RANGE = 2;
    public static final AbilityCore<KariAbility> INSTANCE = new AbilityCore.Builder<KariAbility>("Kari", AbilityCategory.DEVIL_FRUITS, KariAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f, 240.0f), ChargeComponent.getTooltip(60.0f), RangeComponent.getTooltip(2.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.FIRE).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private static final KariParticleEffect.Details DETAILS = new KariParticleEffect.Details();
    private final Interval particleInterval = new Interval(2);

    public KariAbility(AbilityCore<KariAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.rangeComponent);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.particleInterval.restartIntervalToZero();
            this.chargeComponent.startCharging(entity, 60.0f);
        } else {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
        if (this.particleInterval.canTick()) {
            DETAILS.setRange(2);
            DETAILS.setSize(2.0f);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KARI.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), DETAILS);
        }
        float range = this.rangeComponent.getBonusManager().applyBonus(2.0f);
        List<Entity> targets = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, null, Entity.class);
        for (Entity target : targets) {
            if (target instanceof LivingEntity) {
                AbilityHelper.setSecondsOnFireBy(target, 3, entity);
                continue;
            }
            if (!(target instanceof AbilityProjectileEntity)) continue;
            AbilityProjectileEntity abilityProj = (AbilityProjectileEntity)target;
            if (((ModDamageSource)((Object)abilityProj.getDamageSource())).isPhysical()) {
                LivingEntity thrower = abilityProj.getThrower();
                if (thrower == null || thrower == entity) continue;
                AbilityHelper.setSecondsOnFireBy(target, 3, entity);
                continue;
            }
            target.func_70106_y();
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + entity.func_70681_au().nextFloat() * 0.2f);
        float cooldown = Math.max(60.0f, 240.0f * this.chargeComponent.getChargePercentage());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

