/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFifthAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearSecondAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearThirdAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class GomuHelper {
    private static final AbilityCore<?>[] GEARS = new AbilityCore[]{GearSecondAbility.INSTANCE, GearThirdAbility.INSTANCE, GearFourthAbility.INSTANCE};
    public static final AbilityDescriptionLine.IDescriptionLine SECOND_GEAR_REQ = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{StringTextComponent.field_240750_d_, AbilityHelper.mentionAbility(GearSecondAbility.INSTANCE)}));
    public static final AbilityDescriptionLine.IDescriptionLine THIRD_GEAR_REQ = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{StringTextComponent.field_240750_d_, AbilityHelper.mentionAbility(GearThirdAbility.INSTANCE)}));
    public static final AbilityDescriptionLine.IDescriptionLine FOURTH_GEAR_REQ = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{StringTextComponent.field_240750_d_, AbilityHelper.mentionAbility(GearFourthAbility.INSTANCE)}));
    public static final AbilityDescriptionLine.IDescriptionLine FIFTH_GEAR_REQ = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{StringTextComponent.field_240750_d_, AbilityHelper.mentionAbility(GearFifthAbility.INSTANCE)}));

    public static Ability.ICanUseEvent<LivingEntity, IAbility> canUseGearCheck(AbilityCore<?> gear) {
        return (entity, ability) -> {
            IAbilityData props = AbilityDataCapability.get(entity);
            boolean hasOtherGearActive = false;
            for (AbilityCore<?> otherGear : GEARS) {
                boolean isActive;
                Object gearAbility;
                if (gear.equals(otherGear) || (gearAbility = props.getEquippedAbility(otherGear)) == null || !(isActive = gearAbility.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false).booleanValue())) continue;
                hasOtherGearActive = true;
                break;
            }
            if (hasOtherGearActive) {
                return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_GEAR_ACTIVE);
            }
            return AbilityUseResult.success();
        };
    }

    public static boolean hasGearSecondActive(IAbilityData props) {
        Ability ability = props.getEquippedAbility(GearSecondAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    public static boolean hasGearThirdActive(IAbilityData props) {
        Ability ability = props.getEquippedAbility(GearThirdAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    public static boolean hasGearFourthActive(IAbilityData props) {
        Ability ability = props.getEquippedAbility(GearFourthAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    public static boolean hasGearFifthActive(IAbilityData props) {
        Ability ability = props.getEquippedAbility(GearFifthAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    public static enum Gears {
        NO_GEAR,
        GEAR_2,
        GEAR_3,
        GEAR_4,
        GEAR_5;

    }
}

