/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoBazookaProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoGrizzlyMagnumProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetBazookaProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoLeoBazookaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GomuGomuNoBazookaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gomu_gomu_no_bazooka", new Pair[]{ImmutablePair.of((Object)"Hits the enemy with both hands to launch them away.", null)});
    private static final TranslationTextComponent GOMU_GOMU_NO_BAZOOKA_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_bazooka", "Gomu Gomu no Bazooka"));
    private static final TranslationTextComponent GOMU_GOMU_NO_JET_BAZOOKA_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_jet_bazooka", "Gomu Gomu no Jet Bazooka"));
    private static final TranslationTextComponent GOMU_GOMU_NO_GRIZZLY_MAGNUM_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_grizzly_magnum", "Gomu Gomu no Grizzly Magnum"));
    private static final TranslationTextComponent GOMU_GOMU_NO_LEO_BAZOOKA_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_leo_bazooka", "Gomu Gomu no Leo Bazooka"));
    private static final ResourceLocation GOMU_GOMU_NO_BAZOOKA_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_bazooka.png");
    private static final ResourceLocation GOMU_GOMU_NO_JET_BAZOOKA_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_jet_bazooka.png");
    private static final ResourceLocation GOMU_GOMU_NO_GRIZZLY_MAGNUM_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_grizzly_magnum.png");
    private static final ResourceLocation GOMU_GOMU_NO_LEO_BAZOOKA_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_leo_bazooka.png");
    private static final int NO_GEAR_COOLDOWN = 200;
    private static final int NO_GEAR_CHARGE_TIME = 40;
    private static final int SECOND_GEAR_COOLDOWN = 140;
    private static final int SECOND_GEAR_CHARGE_TIME = 30;
    private static final int THIRD_GEAR_COOLDOWN = 300;
    private static final int THIRD_GEAR_CHARGE_TIME = 60;
    private static final int FOURTH_GEAR_COOLDOWN = 240;
    private static final int FOURTH_GEAR_CHARGE_TIME = 40;
    private static final AbilityDescriptionLine.IDescriptionLine NO_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_BAZOOKA_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine SECOND_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_JET_BAZOOKA_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine THIRD_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_GRIZZLY_MAGNUM_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine FOURTH_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_LEO_BAZOOKA_NAME));
    public static final AbilityCore<GomuGomuNoBazookaAbility> INSTANCE = new AbilityCore.Builder<GomuGomuNoBazookaAbility>("Gomu Gomu no Bazooka", AbilityCategory.DEVIL_FRUITS, GomuGomuNoBazookaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, NO_GEAR_NAME_DESC, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(40.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, SECOND_GEAR_NAME_DESC, GomuHelper.SECOND_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ChargeComponent.getTooltip(30.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, THIRD_GEAR_NAME_DESC, GomuHelper.THIRD_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ChargeComponent.getTooltip(60.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, FOURTH_GEAR_NAME_DESC, GomuHelper.FOURTH_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(40.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final AltModeComponent<GomuHelper.Gears> altModeComponent = new AltModeComponent<GomuHelper.Gears>(this, GomuHelper.Gears.class, GomuHelper.Gears.NO_GEAR, true).addChangeModeEvent(this::altModeChangeEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private float cooldown = 200.0f;
    private int chargeTime = 40;
    private float projectileSpeed = 2.0f;
    private float projectileSpread = 1.0f;

    public GomuGomuNoBazookaAbility(AbilityCore<GomuGomuNoBazookaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.altModeComponent, this.chargeComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, this.chargeTime);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.GOMU_BAZOOKA);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), this.chargeTime, 0));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        Object projectile1 = this.projectileComponent.getNewProjectile(entity);
        Object projectile2 = this.projectileComponent.getNewProjectile(entity);
        Vector3d dirVec = Vector3d.field_186680_a;
        Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
        dirVec = dirVec.func_72441_c((double)Math.abs(dir.func_176730_m().func_177958_n()), (double)Math.abs(dir.func_176730_m().func_177956_o()), (double)Math.abs(dir.func_176730_m().func_177952_p()));
        dirVec = dirVec.func_216372_d((double)this.projectileSpread, 1.0, (double)this.projectileSpread);
        projectile1.func_70012_b(entity.func_226277_ct_() + dirVec.field_72449_c, entity.func_226280_cw_(), entity.func_226281_cx_() + dirVec.field_72450_a, 0.0f, 0.0f);
        projectile2.func_70012_b(entity.func_226277_ct_() - dirVec.field_72449_c, entity.func_226280_cw_(), entity.func_226281_cx_() - dirVec.field_72450_a, 0.0f, 0.0f);
        this.projectileComponent.shoot((AbilityProjectileEntity)((Object)projectile1), entity, this.projectileSpeed, 0.0f);
        this.projectileComponent.shoot((AbilityProjectileEntity)((Object)projectile2), entity, this.projectileSpeed, 0.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GOMU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f);
        this.cooldownComponent.startCooldown(entity, this.cooldown);
    }

    private void altModeChangeEvent(LivingEntity entity, IAbility ability, GomuHelper.Gears mode) {
        switch (mode) {
            case GEAR_2: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_JET_BAZOOKA_NAME);
                this.cooldown = 140.0f;
                this.chargeTime = 30;
                break;
            }
            case GEAR_3: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_GRIZZLY_MAGNUM_NAME);
                this.cooldown = 300.0f;
                this.chargeTime = 60;
                break;
            }
            case GEAR_4: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_LEO_BAZOOKA_NAME);
                this.cooldown = 240.0f;
                this.chargeTime = 40;
                break;
            }
            case GEAR_5: {
                break;
            }
            default: {
                this.setDisplayIcon(GOMU_GOMU_NO_BAZOOKA_ICON);
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_BAZOOKA_NAME);
                this.cooldown = 200.0f;
                this.chargeTime = 40;
            }
        }
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get(entity);
        AbilityProjectileEntity projectile = null;
        this.projectileSpeed = 2.0f;
        this.projectileSpread = 1.0f;
        if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoLeoBazookaProjectile(entity.field_70170_p, entity, this);
            this.projectileSpeed = 3.0f;
            this.projectileSpread = 2.5f;
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoGrizzlyMagnumProjectile(entity.field_70170_p, entity, this);
            this.projectileSpeed = 1.8f;
            this.projectileSpread = 2.5f;
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetBazookaProjectile(entity.field_70170_p, entity, this);
            this.projectileSpeed = 3.0f;
        } else {
            projectile = new GomuGomuNoBazookaProjectile(entity.field_70170_p, entity, this);
        }
        return projectile;
    }

    public void switchNoGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.NO_GEAR);
    }

    public void switchSecondGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_2);
    }

    public void switchThirdGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_3);
    }

    public void switchFourthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_4);
    }

    public void switchFifthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_5);
    }
}

