/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoBazookaAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoGatlingAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoPistolAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireAbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GearFourthAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gear_fourth", new Pair[]{ImmutablePair.of((Object)"The user inflates their muscle structure to tremendously increase the power of their attacks and also allows flight.", null)});
    private static final int HOLD_TIME = 1000;
    private static final int MIN_COOLDOWN = 100;
    private static final float MAX_COOLDOWN = 666.6667f;
    public static final AbilityCore<GearFourthAbility> INSTANCE = new AbilityCore.Builder<GearFourthAbility>("Gear Fourth", AbilityCategory.DEVIL_FRUITS, GearFourthAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireAbilityComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 666.6667f), ContinuousComponent.getTooltip(1000.0f), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Gear Fourth Armor Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Gear Fourth Attack Damage Modifier", 15.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Gear Fourth Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.G4_OVERLAY).build();
    private static final RequireAbilityComponent.CheckData HAKI_CHECK = new RequireAbilityComponent.CheckData<BusoshokuHakiFullBodyHardeningAbility>(BusoshokuHakiFullBodyHardeningAbility.INSTANCE, RequireAbilityComponent.START_IF_NOT_ACTIVE);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final RequireAbilityComponent requireAbilityComponent = new RequireAbilityComponent(this, HAKI_CHECK, new RequireAbilityComponent.CheckData[0]);
    private final StackComponent stackComponent = new StackComponent(this).addStackChangeEvent(this::changeStackEvent);
    public float speed = 0.0f;

    public GearFourthAbility(AbilityCore<GearFourthAbility> core) {
        super(core);
        this.addComponents(this.skinOverlayComponent, this.requireAbilityComponent, this.stackComponent);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        this.stackComponent.setDefaultStacks(0);
        this.skinOverlayComponent.showAll(entity);
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchFourthGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchFourthGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchFourthGear(entity);
        }
        if ((flightAbility = (PropelledFlightAbility)props.getPassiveAbility(GearFourthFlightAbility.INSTANCE)) != null && !flightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)entity);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        int stacks;
        float continueTime = this.continuousComponent.getContinueTime();
        if (continueTime % 10.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GEAR_SECOND.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if ((stacks = this.stackComponent.getStacks()) == 0 && (double)continueTime > WyHelper.percentage(50.0, this.continuousComponent.getThresholdTime())) {
            this.stackComponent.addStacks(entity, ability, 1);
        } else if (stacks == 1 && (double)continueTime > WyHelper.percentage(70.0, this.continuousComponent.getThresholdTime())) {
            this.stackComponent.addStacks(entity, ability, 1);
        } else if (stacks == 2 && (double)continueTime > WyHelper.percentage(90.0, this.continuousComponent.getThresholdTime())) {
            this.stackComponent.addStacks(entity, ability, 1);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        this.skinOverlayComponent.hideAll(entity);
        this.stackComponent.revertStacksToDefault(entity, ability);
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchNoGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchNoGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchNoGear(entity);
        }
        if ((flightAbility = (PropelledFlightAbility)props.getPassiveAbility(GearFourthFlightAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)entity);
        }
        float cooldown = Math.max(100.0f, this.continuousComponent.getContinueTime() / 1.5f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private void changeStackEvent(LivingEntity entity, IAbility ability, int stacks) {
        if (stacks == 1) {
            entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 200, 0, true, true));
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 0, true, true));
        } else if (stacks >= 2) {
            entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 400, 0, true, true));
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, 0, true, true));
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 400, 0, true, true));
            if (stacks > 2) {
                this.stackComponent.revertStacksToDefault(entity, ability);
                this.continuousComponent.stopContinuity(entity);
                this.disableComponent.startDisable(entity, 400.0f);
            }
        }
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.GEAR_FOURTH.get();
    }

    @Override
    public float getContinuityHoldTime() {
        return 1000.0f;
    }
}

