/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.NoFallDamageAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class BouncyAbility
extends NoFallDamageAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bouncy", new Pair[]{ImmutablePair.of((Object)"Makes the user bounce upon landing", null)});
    public static final AbilityCore<BouncyAbility> INSTANCE = new AbilityCore.Builder<BouncyAbility>("Bouncy", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, BouncyAbility::new).addDescriptionLine(DESCRIPTION).build();
    private boolean touchedGround = true;
    private float bounceValue = 0.0f;

    public BouncyAbility(AbilityCore<BouncyAbility> ability) {
        super((AbilityCore<? extends NoFallDamageAbility>)ability);
        this.damageTakenComponent.addOnAttackEvent(this::onDamageTaken);
        super.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    protected void duringPassiveEvent(LivingEntity entity) {
        if (entity.field_70143_R > 12.0f || !this.touchedGround) {
            this.touchedGround = false;
            if (entity.field_70143_R != 0.0f) {
                this.bounceValue = entity.field_70143_R;
            }
            if (entity.func_233570_aj_() && this.bounceValue / 30.0f > 0.0f) {
                this.touchedGround = true;
                AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().field_72450_a, (double)this.bounceValue / 30.0, entity.func_213322_ci().field_72449_c);
            }
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.field_188406_j) {
            return 0.0f;
        }
        return damage;
    }
}

