/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goe;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goe.DragonsRoarProjectile;

public class DragonsRoarAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "dragons_roar", new Pair[]{ImmutablePair.of((Object)"The user shouts and creates a series of powerful sound shockwaves.", null)});
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<DragonsRoarAbility> INSTANCE = new AbilityCore.Builder<DragonsRoarAbility>("Dragon's Roar", AbilityCategory.DEVIL_FRUITS, DragonsRoarAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);

    public DragonsRoarAbility(AbilityCore<DragonsRoarAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent, this.repeaterComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 10, 6);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.5f, 1.0f);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private DragonsRoarProjectile createProjectile(LivingEntity entity) {
        float size = Math.abs(this.repeaterComponent.getMaxTriggers() - this.repeaterComponent.getTriggerCount() - 10) * 2;
        DragonsRoarProjectile proj = new DragonsRoarProjectile(entity.field_70170_p, entity, size, (Ability)this);
        return proj;
    }
}

