/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gasu.ShinokuniAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gasu.KoroParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KoroAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "koro", new Pair[]{ImmutablePair.of((Object)"Removes all poison from self and nearby allies.", null), ImmutablePair.of((Object)"If used while %s is active, it'll remove all harmful effects for self and nearby allies.", (Object)new Object[]{ShinokuniAbility.INSTANCE})});
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().testFriendlyFaction();
    private static final int COOLDOWN = 400;
    private static final float RANGE = 30.0f;
    public static final AbilityCore<KoroAbility> INSTANCE = new AbilityCore.Builder<KoroAbility>("Koro", AbilityCategory.DEVIL_FRUITS, KoroAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), RangeComponent.getTooltip(30.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private KoroParticleEffect.Details particleDetails = new KoroParticleEffect.Details();

    public KoroAbility(AbilityCore<KoroAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    public void useEvent(LivingEntity player, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(player, 30.0f, TARGETS_PREDICATE);
        targets.add(player);
        ShinokuniAbility abl = AbilityDataCapability.get(player).getEquippedAbility(ShinokuniAbility.INSTANCE);
        boolean hasShinokuniActive = abl != null && abl.isContinuous();
        for (LivingEntity target : targets) {
            if (hasShinokuniActive) {
                for (EffectInstance inst : target.func_70651_bq()) {
                    if (inst.func_188419_a() instanceof ModEffect && !((ModEffect)inst.func_188419_a()).isRemoveable() || inst.func_188419_a().func_220303_e() != EffectType.HARMFUL || !target.func_195063_d(inst.func_188419_a().getEffect())) continue;
                    this.particleDetails.setEffect(inst);
                    WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KORO.get(), (Entity)player, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), this.particleDetails);
                }
                continue;
            }
            if (!target.func_70644_a(Effects.field_76436_u) || !target.func_195063_d(Effects.field_76436_u)) continue;
            this.particleDetails.setEffect(target.func_70660_b(Effects.field_76436_u));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KORO.get(), (Entity)player, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), this.particleDetails);
        }
        this.cooldownComponent.startCooldown(player, 400.0f);
    }
}

