/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gasu.ShinokuniAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.BigGastilleProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GastilleProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GastilleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gastille", new Pair[]{ImmutablePair.of((Object)"Shoots a beam of lit gas from the users mouth, that explodes on impact", null), ImmutablePair.of((Object)"If %s is active a bigger and more destructive laser will be shot.", (Object)new Object[]{ShinokuniAbility.INSTANCE})});
    private static final int COOLDOWN = 140;
    public static final AbilityCore<GastilleAbility> INSTANCE = new AbilityCore.Builder<GastilleAbility>("Gastille", AbilityCategory.DEVIL_FRUITS, GastilleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.EXPLOSION).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public GastilleAbility(AbilityCore<GastilleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        float projSpeed = 5.5f;
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            projSpeed = 8.0f;
        }
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, 64.0);
        double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
        float damage = 50.0f;
        float size = 0.25f;
        float length = 50.0f;
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition(entity.func_213303_ch(), entity.field_70761_aq, 0.5, 1.15, 0.8);
        LightningEntity bolt = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, projSpeed, this.getCore());
        bolt.setBlocksAffectedLimit(1508);
        bolt.setMaxLife(40);
        bolt.setDamage(damage);
        bolt.setExplosion(5, true, 0.3f);
        bolt.setSize(size);
        bolt.setBoxSizeDivision(1.0);
        bolt.setColor(new Color(13397929));
        bolt.setAngle(100);
        bolt.setTargetTimeToReset(6000);
        bolt.disableExplosionKnockback();
        bolt.setBranches(1);
        bolt.setSegments(1);
        entity.field_70170_p.func_217376_c((Entity)bolt);
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            return new BigGastilleProjectile(entity.field_70170_p, entity);
        }
        return new GastilleProjectile(entity.field_70170_p, entity);
    }
}

