/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DashAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class ElectricalMissileAbility
extends DashAbility {
    private static final float COOLDOWN_BONUS = 0.5f;
    private static final float DAMAGE_BONUS = 2.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "electrical_missile", new Pair[]{ImmutablePair.of((Object)"Powerful and fast forward dash that will stun enemies.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(SulongAbility.INSTANCE), AbilityHelper.mentionText(Math.round(50.0f) + "%"), AbilityHelper.mentionText(Math.round(Math.abs(-1.5f) * 100.0f) + "%")})});
    private static final int COOLDOWN = 180;
    private static final float RANGE = 1.6f;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 1;
    public static final AbilityCore<ElectricalMissileAbility> INSTANCE = new AbilityCore.Builder<ElectricalMissileAbility>("Electrical Missile", AbilityCategory.RACIAL, ElectricalMissileAbility::new).addDescriptionLine(DESCRIPTION[0]).addAdvancedDescriptionLine(AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[1])).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(180.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricalMissileAbility::canUnlock).build();
    private double dashSpeed = 4.0;

    public ElectricalMissileAbility(AbilityCore<ElectricalMissileAbility> core) {
        super((AbilityCore<? extends DashAbility>)core);
        this.addCanUseCheck(ElectroHelper.requireEleclaw(1));
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean hasSulongActive = ElectroHelper.hasSulongActive(entity);
        this.dashSpeed = hasSulongActive ? 5.0 : 4.0;
        this.dealDamageComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_DAMAGE_BONUS);
        this.cooldownComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_COOLDOWN_BONUS);
        if (hasSulongActive) {
            this.dealDamageComponent.getBonusManager().addBonus(ElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.5f);
            this.cooldownComponent.getBonusManager().addBonus(ElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.5f);
        }
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        EleclawAbility eleclawAbility = AbilityDataCapability.get(entity).getEquippedAbility(EleclawAbility.INSTANCE);
        if (eleclawAbility != null) {
            eleclawAbility.reduceUsage(entity, 1);
        }
    }

    @Override
    public void onTargetHit(LivingEntity entity, LivingEntity target, float damage, DamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 40, 0, false, false, true));
    }

    @Override
    public float getDashCooldown() {
        return 180.0f;
    }

    @Override
    public float getDamage() {
        return 20.0f;
    }

    @Override
    public float getRange() {
        return 1.6f;
    }

    @Override
    public double getSpeed() {
        return this.dashSpeed;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isMink() && props.getDoriki() >= 800.0;
    }
}

