/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class DoruDoruBallAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doru_doru_ball", new Pair[]{ImmutablePair.of((Object)"Puts the user into a hardened wax ball for max defense", null)});
    private static final float HOLD_TIME = 200.0f;
    private static final float MIN_COOLDOWN = 30.0f;
    private static final float MAX_COOLDOWN = 230.0f;
    public static final AbilityCore<DoruDoruBallAbility> INSTANCE = new AbilityCore.Builder<DoruDoruBallAbility>("Doru Doru Ball", AbilityCategory.DEVIL_FRUITS, DoruDoruBallAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(30.0f, 230.0f), ContinuousComponent.getTooltip(200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
    public double rotateAngleX = 0.0;
    public double rotateAngleZ = 0.0;

    public DoruDoruBallAbility(AbilityCore<DoruDoruBallAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.poolComponent);
        this.addUseEvent(100, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.rotateAngleX = 0.0;
        this.rotateAngleZ = 0.0;
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean isAcitve;
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 5, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 20, 5, false, false));
        int power = 5;
        CandleChampionAbility candleChampionAbility = AbilityDataCapability.get(entity).getEquippedAbility(CandleChampionAbility.INSTANCE);
        if (candleChampionAbility != null && (isAcitve = candleChampionAbility.getComponent(ModAbilityKeys.CONTINUOUS).map(ContinuousComponent::isContinuous).orElse(false).booleanValue())) {
            power = 10;
        }
        if (!entity.func_70027_ad()) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING_WITH_MOVEMENT.get(), 2, power, false, false));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.rotateAngleX = 0.0;
        this.rotateAngleZ = 0.0;
        entity.func_195063_d(Effects.field_76421_d);
        entity.func_195063_d(Effects.field_76419_f);
        float cooldown = 30.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

