/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class DokuGumoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doku_gumo", new Pair[]{ImmutablePair.of((Object)"Creates a dense cloud of poisonous smoke, which moves along with the user and poisons and blinds everyone inside.", null)});
    private static final UUID VENOM_RANGE_BONUS_UUID = UUID.fromString("77d2625c-c112-4ebf-9f1e-01311c66968b");
    private static final ITextComponent NORMAL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.doku_gumo", "Doku Gumo"));
    private static final ITextComponent VENOM_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.doku_gumo_venom", "Venom Doku Gumo"));
    private static final ResourceLocation NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/doku_gumo.png");
    private static final ResourceLocation VENOM_ICON = new ResourceLocation("mineminenomi", "textures/abilities/doku_gumo_venom.png");
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 400;
    private static final int RANGE = 10;
    public static final AbilityCore<DokuGumoAbility> INSTANCE = new AbilityCore.Builder<DokuGumoAbility>("Doku Gumo", AbilityCategory.DEVIL_FRUITS, DokuGumoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ContinuousComponent.getTooltip(400.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.POISON).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);

    public DokuGumoAbility(AbilityCore<DokuGumoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.altModeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    private void duringContinuityEvent(LivingEntity player, IAbility ability) {
        int power = 0;
        int duration = 100;
        boolean hasVenomDemon = false;
        int poisonIntensity = 0;
        if (((MorphInfo)ModMorphs.VENOM_DEMON.get()).isActive(player)) {
            hasVenomDemon = true;
            power += 2;
            duration *= 2;
            this.rangeComponent.getBonusManager().addBonus(VENOM_RANGE_BONUS_UUID, "Venom Range Bonus", BonusOperation.MUL, 2.0f);
            poisonIntensity = 1;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(player, 10.0f);
        for (LivingEntity target : targets) {
            if (!target.func_70644_a(Effects.field_76440_q)) {
                target.func_195064_c(new EffectInstance(Effects.field_76440_q, duration, power));
            }
            if (!target.func_70644_a((Effect)ModEffects.DOKU_POISON.get())) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), duration, poisonIntensity));
            }
            if (target.func_70644_a(Effects.field_76437_t)) continue;
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, duration, power));
        }
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DOKU_GUMO.get(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), hasVenomDemon ? DokuHelper.DETAILS : null);
        }
    }

    private void endContinuityEvent(LivingEntity player, IAbility ability) {
        this.cooldownComponent.startCooldown(player, 600.0f);
    }

    public void setNormalMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.NORMAL);
    }

    public void setVenomMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.VENOM);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.VENOM) {
            super.setDisplayName(VENOM_NAME);
            super.setDisplayIcon(VENOM_ICON);
        } else if (mode == Mode.NORMAL) {
            super.setDisplayName(NORMAL_NAME);
            super.setDisplayIcon(NORMAL_ICON);
        }
    }

    private static enum Mode {
        NORMAL,
        VENOM;

    }
}

