/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MedicBagExplosionAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "medic_bag_explosion", new Pair[]{ImmutablePair.of((Object)"By sacrificing the medic bag's durability the user can heal themselves with regeneration while applying debuffs to nearby enemies.", null)});
    public static final TargetsPredicate ENEMY_AREA_CHECK = new TargetsPredicate().testEnemyFaction();
    public static final TargetsPredicate FRIENDLY_AREA_CHECK = new TargetsPredicate().testFriendlyFaction();
    private static final int COOLDOWN = 800;
    private static final int RANGE = 10;
    private static final int MIN_HEAL = 5;
    private static final int MAX_HEAL = 50;
    public static final AbilityCore<MedicBagExplosionAbility> INSTANCE = new AbilityCore.Builder<MedicBagExplosionAbility>("Medic Bag Explosion", AbilityCategory.STYLE, MedicBagExplosionAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(800.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE), HealComponent.getTooltip(5.0f, 50.0f)).setUnlockCheck(MedicBagExplosionAbility::canUnlock).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final HealComponent healComponent = new HealComponent(this);

    public MedicBagExplosionAbility(AbilityCore<MedicBagExplosionAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.healComponent);
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        boolean hasMedicBag;
        boolean isHandEmpty = entity.func_184614_ca().func_190926_b();
        ItemStack medicBag = !isHandEmpty ? entity.func_184614_ca() : entity.func_184582_a(EquipmentSlotType.CHEST);
        boolean bl = hasMedicBag = medicBag.func_77973_b() == ModArmors.MEDIC_BAG.get();
        if (!hasMedicBag) {
            return;
        }
        float heal = (float)MathHelper.func_151237_a((double)WyHelper.percentage(20.0, entity.func_110138_aP()), (double)5.0, (double)50.0);
        this.healComponent.healTarget(entity, entity, heal);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f, ENEMY_AREA_CHECK);
        for (LivingEntity target : targets) {
            int effect = (int)WyHelper.randomWithRange(0, 6);
            switch (effect) {
                case 0: {
                    target.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1));
                    break;
                }
                case 1: {
                    target.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 1));
                    break;
                }
                case 2: {
                    target.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 1));
                    break;
                }
                case 3: {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                    break;
                }
                case 4: {
                    target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
                    break;
                }
                case 5: {
                    target.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1));
                    break;
                }
                case 6: {
                    target.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1));
                    break;
                }
            }
        }
        List<LivingEntity> friendlies = this.rangeComponent.getTargetsInArea(entity, 10.0f, FRIENDLY_AREA_CHECK);
        for (LivingEntity target : friendlies) {
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 2));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.MEDIC_BAG_EXPLOSION.get(), (Entity)entity, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
        this.cooldownComponent.startCooldown(entity, 800.0f);
        medicBag.func_222118_a(250, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_03);
    }
}

