/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class FailedExperimentAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "failed_experiment", new Pair[]{ImmutablePair.of((Object)"Throws a random splash potion with a debuff effect at the enemy.", null)});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<FailedExperimentAbility> INSTANCE = new AbilityCore.Builder<FailedExperimentAbility>("Failed Experiment", AbilityCategory.STYLE, FailedExperimentAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).setUnlockCheck(FailedExperimentAbility::canUnlock).build();
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.ATTACK_SPEED).addChangeModeEvent(this::onAltModeChange);
    private ItemStack stack = new ItemStack((IItemProvider)Items.field_185155_bH);

    public FailedExperimentAbility(AbilityCore<FailedExperimentAbility> core) {
        super(core);
        this.isNew = true;
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        super.addComponents(this.altModeComponent);
        super.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity livingEntity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.ATTACK_SPEED) {
            this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 200, 1)}));
        }
        PotionEntity potion = new PotionEntity(livingEntity.field_70170_p, livingEntity);
        potion.func_213884_b(this.stack);
        potion.field_70125_A -= -20.0f;
        potion.func_234612_a_((Entity)livingEntity, livingEntity.field_70125_A, livingEntity.field_70177_z, -20.0f, 1.0f, 0.0f);
        livingEntity.field_70170_p.func_217376_c((Entity)potion);
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            ItemStack medicBag = (ItemStack)player.field_71071_by.field_70460_b.get(2);
            medicBag.func_222118_a(10, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        this.cooldownComponent.startCooldown(livingEntity, 240.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        switch (mode) {
            case POISON: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 200, 1)}));
                break;
            }
            case HUNGER: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76438_s, 200, 1)}));
                break;
            }
            case ATTACK_SPEED: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 200, 1)}));
                break;
            }
            case CONFUSION: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76431_k, 200, 1)}));
                break;
            }
            case SLOWNESS: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76421_d, 200, 1)}));
                break;
            }
            case BLINDNESS: {
                this.stack = PotionUtils.func_185184_a((ItemStack)this.stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76440_q, 200, 1)}));
            }
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_02);
    }

    public static enum Mode {
        CONFUSION,
        ATTACK_SPEED,
        POISON,
        HUNGER,
        SLOWNESS,
        BLINDNESS;

    }
}

