/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DopingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doping", new Pair[]{ImmutablePair.of((Object)"Injects the target with special medicine that boosts their physical powers.", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: User injects themselves", null)});
    private static final int COOLDOWN = 500;
    private static final int EFFECT_TIME = 200;
    public static final AbilityCore<DopingAbility> INSTANCE = new AbilityCore.Builder<DopingAbility>("Doping", AbilityCategory.STYLE, DopingAbility::new).addDescriptionLine(DESCRIPTION).setSourceType(SourceType.FIST).setUnlockCheck(DopingAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::hitEvent);

    public DopingAbility(AbilityCore<DopingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTriggerComponent);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_213453_ef()) {
            this.applyEffect(entity, entity);
            return;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            source.setBypassFriendlyDamage();
            this.applyEffect(entity, target);
        }
        return true;
    }

    private void applyEffect(LivingEntity entity, LivingEntity target) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.TENSION_HORMONE.get(), 200, 1));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FIRST_AID.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.continuousComponent.stopContinuity(entity);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_03);
    }
}

