/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AntidoteShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "antidote_shot", new Pair[]{ImmutablePair.of((Object)"Injects the target with an antidote making them immune to certain negative effects.", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: User injects themselves", null)});
    private static final int COOLDOWN = 300;
    private static final int EFFECT_TIME = 200;
    public static final AbilityCore<AntidoteShotAbility> INSTANCE = new AbilityCore.Builder<AntidoteShotAbility>("Antidote Shot", AbilityCategory.STYLE, AntidoteShotAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHitEvent);

    public AntidoteShotAbility(AbilityCore<AntidoteShotAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.hitTriggerComponent);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
        if (entity.func_213453_ef()) {
            this.applyAntidoteEffect(entity, entity);
            return;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.applyAntidoteEffect(entity, target);
        }
        return true;
    }

    private void applyAntidoteEffect(LivingEntity entity, LivingEntity target) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTIDOTE.get(), 200, 0));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FIRST_AID.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.continuousComponent.stopContinuity(entity);
    }
}

