/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doa;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DoorDoorAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "door_door", new Pair[]{ImmutablePair.of((Object)"By making a door, the user transports to the other side of any surface.", null)});
    private static final int COOLDOWN = 100;
    public static final AbilityCore<DoorDoorAbility> INSTANCE = new AbilityCore.Builder<DoorDoorAbility>("Door Door", AbilityCategory.DEVIL_FRUITS, DoorDoorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).build();

    public DoorDoorAbility(AbilityCore<DoorDoorAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        BlockRayTraceResult hitBlock = WyHelper.rayTraceBlocks((Entity)entity, 16.0);
        if (Math.sqrt(entity.func_195048_a(hitBlock.func_216347_e())) > 2.5) {
            return;
        }
        Vector3d look = entity.func_70040_Z().func_72432_b();
        Vector3d vec = entity.func_213303_ch();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        boolean firstSolid = false;
        int airBlocks = 0;
        for (int i = 0; i < 40; ++i) {
            BlockState state = entity.field_70170_p.func_180495_p((BlockPos)pos);
            if (state.func_177230_c() == Blocks.field_150350_a && (firstSolid || airBlocks > 1)) {
                entity.func_233576_c_(vec.func_72441_c(0.0, 1.0, 0.0));
                break;
            }
            vec = vec.func_72441_c(look.field_72450_a, look.field_72448_b, look.field_72449_c);
            pos.func_181079_c(MathHelper.func_76128_c((double)vec.field_72450_a), MathHelper.func_76143_f((double)vec.field_72448_b), MathHelper.func_76128_c((double)vec.field_72449_c));
            state = entity.field_70170_p.func_180495_p((BlockPos)pos);
            if (state.func_185904_a().func_76220_a()) {
                firstSolid = true;
            }
            if (state.func_177230_c() != Blocks.field_150350_a) continue;
            ++airBlocks;
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DOA_IN_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }
}

