/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doa;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class AirDoorAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "air_door", new Pair[]{ImmutablePair.of((Object)"The user travels into an air dimension and is invincible during that time.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 800;
    public static final AbilityCore<AirDoorAbility> INSTANCE = new AbilityCore.Builder<AirDoorAbility>("Air Door", AbilityCategory.DEVIL_FRUITS, AirDoorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 800.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::damageTakenEvent);

    public AirDoorAbility(AbilityCore<AirDoorAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DOA_INVISIBILITY.get(), 1200, 0, false, false));
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DOA_IN_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195063_d((Effect)ModEffects.DOA_INVISIBILITY.get());
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DOA_OUT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        float cooldown = 200.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public float damageTakenEvent(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous()) {
            return 0.0f;
        }
        return damage;
    }
}

