/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.CyborgHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CoupDeBooAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "coup_de_boo", new Pair[]{ImmutablePair.of((Object)"Launches the user into the sky.", null)});
    private static final float COOLDOWN = 200.0f;
    private static final int COLA_REQUIRED = 20;
    private static final int RANGE = 5;
    public static final AbilityCore<CoupDeBooAbility> INSTANCE = new AbilityCore.Builder<CoupDeBooAbility>("Coup De Boo", AbilityCategory.RACIAL, CoupDeBooAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), CyborgHelper.getColaTooltip(20.0f), RangeComponent.getTooltip(5.0f, RangeComponent.RangeType.AOE)).setUnlockCheck(CoupDeBooAbility::canUnlock).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private boolean hasFallDamage = true;

    public CoupDeBooAbility(AbilityCore<CoupDeBooAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.damageTakenComponent, this.rangeComponent);
        this.addCanUseCheck(CyborgHelper.hasEnoughCola(20));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        IEntityStats props = EntityStatsCapability.get(entity);
        Vector3d speed = WyHelper.propulsion(entity, 2.0, 1.5, 2.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, speed.field_72448_b + 3.5, speed.field_72449_c);
        props.alterCola(-20);
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo(new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.COUP_DE_BOO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        for (LivingEntity target : this.rangeComponent.getTargetsInArea(entity, 5.0f)) {
            target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isCyborg();
    }
}

