/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RyuNoIbukiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ryu_no_ibuki", new Pair[]{ImmutablePair.of((Object)"The user puts their clenched fists into the ground, creating an immense impact and centered all-directional fissure.", null)});
    private static final int EXPLOSION_RADIUS = 15;
    private static final int EXPLOSION_DEPTH = 3;
    private static final int COOLDOWN = 500;
    private static final int CHARGE_TIME = 30;
    public static final AbilityCore<RyuNoIbukiAbility> INSTANCE = new AbilityCore.Builder<RyuNoIbukiAbility>("Ryu no Ibuki", AbilityCategory.STYLE, RyuNoIbukiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(500.0f), ChargeComponent.getTooltip(30.0f), RangeComponent.getTooltip(15.0f, RangeComponent.RangeType.AOE)).setUnlockCheck(RyuNoIbukiAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final List<BlockPos> affectedBlocks = new ArrayList<BlockPos>();
    private final BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(5);
    private final Interval particleInterval = new Interval(5);

    public RyuNoIbukiAbility(AbilityCore<RyuNoIbukiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.animationComponent, this.rangeComponent, this.dealDamageComponent);
        super.addCanUseCheck(AbilityHelper::requiresOnGround);
        super.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 30.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        int radiusXZ = 7;
        List allPositions = WyHelper.getNearbyBlocks(entity.func_233580_cy_(), (IWorld)entity.field_70170_p, radiusXZ, 3, radiusXZ, state -> !state.func_177230_c().equals(Blocks.field_150350_a)).stream().filter(pos -> DefaultProtectionRules.CORE_FOLIAGE_ORE.check(entity.field_70170_p, (BlockPos)pos, entity.field_70170_p.func_180495_p(pos))).collect(Collectors.toList());
        Collections.shuffle(allPositions, entity.func_70681_au());
        for (int i = 0; i < allPositions.size(); ++i) {
            if (i % 2 != 1) continue;
            this.affectedBlocks.add((BlockPos)allPositions.get(i));
        }
        this.affectedBlocks.forEach(this.details::addPosition);
        this.animationComponent.start(entity, ModAnimations.RYU_NO_IBUKI, 30);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.details);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 15.0f);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch().func_178786_a(0.0, 3.0, 0.0), target.func_213303_ch().func_72441_c(0.0, 3.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 5, 0, false, false)));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 15.0f);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch().func_178786_a(0.0, 3.0, 0.0), target.func_213303_ch().func_72441_c(0.0, 3.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 80, 0, false, false)));
        ProtectedArea area = ProtectedAreasData.get(entity.field_70170_p).getProtectedArea((int)entity.func_226277_ct_(), (int)entity.func_226278_cu_(), (int)entity.func_226281_cx_());
        if (area == null || area.canDestroyBlocks()) {
            for (BlockPos pos : this.affectedBlocks) {
                FallingBlockEntity block = new FallingBlockEntity(entity.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), entity.field_70170_p.func_180495_p(pos));
                Vector3d dirVec = entity.func_213303_ch().func_178788_d(block.func_213303_ch()).func_72432_b();
                AbilityHelper.setDeltaMovement((Entity)block, dirVec.field_72450_a * WyHelper.randomDouble() * 2.0, dirVec.field_72448_b + 0.5, dirVec.field_72449_c * WyHelper.randomDouble() * 2.0);
                block.field_145813_c = false;
                block.field_145812_b = 1;
                entity.field_70170_p.func_217376_c((Entity)block);
                AbilityHelper.placeBlockIfAllowed(entity, pos, Blocks.field_150350_a.func_176223_P(), null);
            }
        }
        this.affectedBlocks.clear();
        this.details.clearPositions();
        this.particleInterval.restartIntervalToZero();
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_04);
    }
}

