/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GenkotsuMeteorAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "genkotsu_meteor", new Pair[]{ImmutablePair.of((Object)"Throws a cannon ball from the user's hand or multiple cannon balls in \u00a7aRyuseigun\u00a7r mode", null)});
    private static final TranslationTextComponent GENKOTSU_MODE_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.genkotsu_meteor", "Genkotsu Meteor"));
    private static final TranslationTextComponent RYUSEIGUN_MODE_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.genkotsu_meteor_ryuseigun", "Ryuseigun"));
    private static final ResourceLocation GENKOTSU_METEOR_NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/genkotsu_meteor.png");
    private static final ResourceLocation GENKOTSU_METEOR_RYUSEIGUN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/genkotsu_meteor_ryuseigun.png");
    private static final float NORMAL_COOLDOWN = 60.0f;
    private static final float RYUSEIGUN_COOLDOWN = 200.0f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<GenkotsuMeteorAbility> INSTANCE = new AbilityCore.Builder<GenkotsuMeteorAbility>("Genkotsu Meteor", AbilityCategory.STYLE, GenkotsuMeteorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> GENKOTSU_MODE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), CooldownComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(15.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> RYUSEIGUN_MODE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(15.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.PHYSICAL, SourceType.INDIRECT).setUnlockCheck(GenkotsuMeteorAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.NORMAL).addChangeModeEvent(this::onAltModeChange);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private ItemStack cannonBalls = null;

    public GenkotsuMeteorAbility(AbilityCore<GenkotsuMeteorAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.altModeComponent, this.projectileComponent);
        this.addCanUseCheck(this::canUseAbility);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems(entity)) {
            if (!itemStack.func_77973_b().equals(ModItems.CANNON_BALL.get())) continue;
            this.cannonBalls = itemStack;
            break;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            this.repeaterComponent.start(entity, 1, 1);
        } else if (this.altModeComponent.getCurrentMode() == Mode.RYUSEIGUN) {
            this.repeaterComponent.start(entity, 10, 4);
        }
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (this.cannonBalls == null || this.cannonBalls.func_190916_E() == 0 || this.canUseAbility(entity, ability).isFail()) {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS), Util.field_240973_b_);
            this.repeaterComponent.stop(entity);
            return;
        }
        this.cannonBalls.func_190918_g(1);
        float inaccuracy = this.altModeComponent.getCurrentMode() == Mode.NORMAL ? 0.0f : 2.0f;
        this.projectileComponent.shoot(entity, 3.0f, inaccuracy);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            this.cooldownComponent.startCooldown(entity, 60.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.RYUSEIGUN) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NORMAL) {
            super.setDisplayIcon(GENKOTSU_METEOR_NORMAL_ICON);
        } else if (mode == Mode.RYUSEIGUN) {
            super.setDisplayIcon(GENKOTSU_METEOR_RYUSEIGUN_ICON);
        }
    }

    private CannonBallProjectile createProjectile(LivingEntity entity) {
        CannonBallProjectile proj = new CannonBallProjectile(entity.field_70170_p, entity, INSTANCE);
        proj.setDamage(15.0f);
        proj.onBlockImpactEvent = hit -> {
            if (proj.field_70173_aa < 2) {
                return;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj.getThrower(), entity.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 1.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        return proj;
    }

    private AbilityUseResult canUseAbility(LivingEntity entity, IAbility ability) {
        if (entity.func_184614_ca().func_190926_b() && ItemsHelper.countItemInInventory(entity, (Item)ModItems.CANNON_BALL.get()) > 0 || entity.func_184614_ca().func_77973_b().equals(ModItems.CANNON_BALL.get())) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS));
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_03);
    }

    public static enum Mode {
        NORMAL,
        RYUSEIGUN;

    }
}

