/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class ChargedPunchAbility
extends Ability {
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 20;
    private static final float DAMAGE = 20.0f;
    private static final int RANGE = 4;
    public static final AbilityCore<ChargedPunchAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Charged Punch", AbilityCategory.STYLE, ChargedPunchAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(20.0f), RangeComponent.getTooltip(4.0f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::stopChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final DealDamageComponent damageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public ChargedPunchAbility(AbilityCore<ChargedPunchAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent, this.damageComponent, this.rangeComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0));
        this.animationComponent.start(entity, ModAnimations.CHARGE_PUNCH);
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 4.0f, 2.0f);
        for (LivingEntity target : targets) {
            if (!this.damageComponent.hurtTarget(entity, target, 20.0f)) continue;
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(2.5, 1.0, 2.5);
            AbilityHelper.setDeltaMovement((Entity)target, dirVec.field_72450_a, 0.2, dirVec.field_72449_c);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

