/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class KickBombAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kick_bomb", new Pair[]{ImmutablePair.of((Object)"The user kicks the ground, detonating their leg on impact", null)});
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<KickBombAbility> INSTANCE = new AbilityCore.Builder<KickBombAbility>("Kick Bomb", AbilityCategory.DEVIL_FRUITS, KickBombAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.EXPLOSION).build();

    public KickBombAbility(AbilityCore<KickBombAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 7.0f);
            explosion.setStaticDamage(70.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(8));
            explosion.doExplosion();
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

