/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.ExtraHachisProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.PoeleAFrireProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class ExtraHachisAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "extra_hachi", new Pair[]{ImmutablePair.of((Object)"Launches a rapid barrage of kicks", null)});
    private static final TranslationTextComponent POELE_A_FRIRE_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.poele_a_frire", "Po\u00eale \u00e0 Frire"));
    private static final ResourceLocation POELE_A_FRIRE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/poele_a_frire.png");
    private static final float NORMAL_COOLDOWN = 240.0f;
    private static final float POELE_A_FRIRE_COOLDOWN = 300.0f;
    public static final AbilityCore<ExtraHachisAbility> INSTANCE = new AbilityCore.Builder<ExtraHachisAbility>("Extra Hachis", AbilityCategory.STYLE, ExtraHachisAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(ExtraHachisAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);

    public ExtraHachisAbility(AbilityCore<ExtraHachisAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.altModeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.repeaterComponent.start(entity, 20, 2);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        int projectileSpace = 2;
        float speed = 2.0f;
        Vector3d pos = new Vector3d(entity.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), entity.func_226278_cu_() + 1.5 + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble(), entity.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble());
        ExtraHachisProjectile extraHachisProjectile = new ExtraHachisProjectile(entity.field_70170_p, entity, this);
        if (this.altModeComponent.getCurrentMode() == Mode.POELE_A_FRIRE) {
            speed = 3.0f;
            PoeleAFrireProjectile poeleAFrireProjectile = new PoeleAFrireProjectile(entity.field_70170_p, entity, this);
            poeleAFrireProjectile.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)poeleAFrireProjectile);
            poeleAFrireProjectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 3.0f);
        }
        extraHachisProjectile.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
        entity.field_70170_p.func_217376_c((Entity)extraHachisProjectile);
        extraHachisProjectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, 3.0f);
        ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.NORMAL) {
            this.cooldownComponent.startCooldown(entity, 240.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.POELE_A_FRIRE) {
            this.cooldownComponent.startCooldown(entity, 300.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NORMAL) {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        } else if (mode == Mode.POELE_A_FRIRE) {
            super.setDisplayName((ITextComponent)POELE_A_FRIRE_NAME);
            super.setDisplayIcon(POELE_A_FRIRE_ICON);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_02);
    }

    public static enum Mode {
        NORMAL,
        POELE_A_FRIRE;

    }
}

