/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bara;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.OutOfBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.BottomHalfBodyEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket2;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class BaraSplitAbility
extends OutOfBodyAbility<BottomHalfBodyEntity> {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bara_split", new Pair[]{ImmutablePair.of((Object)"Allows the user to split its upper part of the body from the lower.", null)});
    private static final int HOLD_TIME = 1000;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 1000;
    public static final AbilityCore<BaraSplitAbility> INSTANCE = new AbilityCore.Builder<BaraSplitAbility>("Bara Split", AbilityCategory.DEVIL_FRUITS, BaraSplitAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 1000.0f), ContinuousComponent.getTooltip(1000.0f)).build();
    private final MorphComponent morphComponent = new MorphComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.BARA_ABILITY, new AbilityPool2[0]);
    private BottomHalfBodyEntity legs;

    public BaraSplitAbility(AbilityCore<BaraSplitAbility> core) {
        super(core);
        this.addComponents(this.morphComponent, this.poolComponent);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.BARA_SPLIT.get());
        AbilityHelper.setDeltaMovement((Entity)entity, 0.0, 2.0, 0.0);
        this.legs = new BottomHalfBodyEntity(entity.field_70170_p);
        this.legs.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.legs.setOwner(entity);
        entity.field_70170_p.func_217376_c((Entity)this.legs);
        this.legs.setParentAbility(this);
        this.setOriginalBody(this.legs);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        float time = this.continuousComponent.getContinueTime();
        if (this.legs != null) {
            this.setPivotPoint(this.legs.func_233580_cy_());
        }
        if (time > 5.0f && entity.func_233570_aj_()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (time % 20.0f == 0.0f) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket2(entity, this), (Entity)entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        float cooldown = Math.max(100.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Override
    public int getHoldTime() {
        return 1000;
    }

    @Override
    public float getMaxRange() {
        return 40.0f;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }
}

