/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bara;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bara.BaraBaraHoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class BaraBaraHoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bara_bara_ho", new Pair[]{ImmutablePair.of((Object)"Launches the user's fist towards the enemy, if the user holds a weapon in hand this will increase the fist's damage as well.", null)});
    private static final int COOLDOWN = 80;
    public static final AbilityCore<BaraBaraHoAbility> INSTANCE = new AbilityCore.Builder<BaraBaraHoAbility>("Bara Bara Ho", AbilityCategory.DEVIL_FRUITS, BaraBaraHoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final MorphComponent morphComponent = new MorphComponent(this);
    private int morphTick;

    public BaraBaraHoAbility(AbilityCore<BaraBaraHoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.morphComponent);
        this.addCanUseCheck(BaraHelper::hasLimbs);
        this.addTickEvent(this::tickEvent);
        this.addUseEvent(this::useEvent);
    }

    private void tickEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.morphComponent.isMorphed()) {
            if (this.morphTick > 0) {
                --this.morphTick;
            } else {
                this.morphComponent.stopMorph(entity);
            }
        }
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        int projectileLife = this.projectileComponent.getShotProjectile().getLife();
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.BARA_HO.get());
        this.morphTick = projectileLife;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), projectileLife, 0));
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }

    private BaraBaraHoProjectile createProjectile(LivingEntity entity) {
        BaraBaraHoProjectile proj = new BaraBaraHoProjectile(entity.field_70170_p, entity);
        ItemStack stack = entity.func_184614_ca();
        float extraDamage = 0.0f;
        if (ItemsHelper.isSword(stack)) {
            extraDamage = ItemsHelper.getItemDamage(stack);
        }
        proj.setDamage(proj.getDamage() + extraDamage);
        return proj;
    }
}

